/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.idl.ast;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FixedNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StringNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.TypeMapper;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.ast.WStringNode;
import com.inprise.vbroker.compiler.backends.common.CommonOptions;

public class IDLMapper
extends TypeMapper {
    public IDLMapper(CommonOptions options) {
        super(options);
    }

    protected final String context2string(int context) {
        return null;
    }

    public String fullName(ContainedNode node, String s) {
        this._buf.reset();
        if (node._container.kind() != 17) {
            this._buf.append(((ContainedNode)((Object)node._container))._beFullName);
        }
        this._buf.append("::");
        this._buf.append(s);
        return this._buf.toString();
    }

    protected void initializeKeywordAvoider() {
        this._keywordAvoider.caseSensitive(false);
        this._keywordAvoider.avoid("FALSE");
        this._keywordAvoider.avoid("Object");
        this._keywordAvoider.avoid("TRUE");
        this._keywordAvoider.avoid("ValueBase");
        this._keywordAvoider.avoid("abstract");
        this._keywordAvoider.avoid("any");
        this._keywordAvoider.avoid("attribute");
        this._keywordAvoider.avoid("boolean");
        this._keywordAvoider.avoid("case");
        this._keywordAvoider.avoid("char");
        this._keywordAvoider.avoid("const");
        this._keywordAvoider.avoid("context");
        this._keywordAvoider.avoid("custom");
        this._keywordAvoider.avoid("default");
        this._keywordAvoider.avoid("double");
        this._keywordAvoider.avoid("enum");
        this._keywordAvoider.avoid("exception");
        this._keywordAvoider.avoid("factory");
        this._keywordAvoider.avoid("fixed");
        this._keywordAvoider.avoid("float");
        this._keywordAvoider.avoid("in");
        this._keywordAvoider.avoid("inout");
        this._keywordAvoider.avoid("interface");
        this._keywordAvoider.avoid("long");
        this._keywordAvoider.avoid("module");
        this._keywordAvoider.avoid("octet");
        this._keywordAvoider.avoid("oneway");
        this._keywordAvoider.avoid("out");
        this._keywordAvoider.avoid("private");
        this._keywordAvoider.avoid("public");
        this._keywordAvoider.avoid("raises");
        this._keywordAvoider.avoid("readonly");
        this._keywordAvoider.avoid("sequence");
        this._keywordAvoider.avoid("short");
        this._keywordAvoider.avoid("string");
        this._keywordAvoider.avoid("struct");
        this._keywordAvoider.avoid("supports");
        this._keywordAvoider.avoid("switch");
        this._keywordAvoider.avoid("truncatable");
        this._keywordAvoider.avoid("typedef");
        this._keywordAvoider.avoid("union");
        this._keywordAvoider.avoid("unsigned");
        this._keywordAvoider.avoid("valuetype");
        this._keywordAvoider.avoid("void");
        this._keywordAvoider.avoid("wchar");
        this._keywordAvoider.avoid("wstring");
    }

    public String map(AliasNode node, int context, ContainerNode useSite) {
        return this.relativeName(node, useSite);
    }

    public String map(ArrayNode node, int context, ContainerNode useSite) {
        this._buf.reset();
        this._buf.append(this.map(node._type, context, useSite));
        this._buf.append('[');
        this._buf.append(Integer.toString(node._length));
        this._buf.append(']');
        return this._buf.toString();
    }

    public String map(EnumNode node, int context, ContainerNode useSite) {
        return this.relativeName(node, useSite);
    }

    public String map(ExceptionNode node, int context, ContainerNode useSite) {
        return this.relativeName(node, useSite);
    }

    public String map(FixedNode node, int context, ContainerNode useSite) {
        return "fixed";
    }

    public String map(InterfaceNode node, int context, ContainerNode useSite) {
        return this.relativeName(node, useSite);
    }

    public String map(PrimitiveNode node, int context, ContainerNode useSite) {
        return node.typeName();
    }

    public String map(SequenceNode node, int context, ContainerNode useSite) {
        this._buf.reset();
        this._buf.append('<');
        this._buf.append(this.map(node._type, context, useSite));
        if (node._bound > 0) {
            this._buf.append(',');
            this._buf.append(Integer.toString(node._bound));
        }
        this._buf.append('>');
        return "sequence".concat(String.valueOf(this._buf.toString()));
    }

    public String map(StringNode node, int context, ContainerNode useSite) {
        return "string";
    }

    public String map(StructNode node, int context, ContainerNode useSite) {
        return this.relativeName(node, useSite);
    }

    public String map(UnionNode node, int context, ContainerNode useSite) {
        return this.relativeName(node, useSite);
    }

    public String map(ValueBoxNode node, int context, ContainerNode useSite) {
        return this.relativeName(node, useSite);
    }

    public String map(ValueNode node, int context, ContainerNode useSite) {
        return this.relativeName(node, useSite);
    }

    public String map(WStringNode node, int context, ContainerNode useSite) {
        return "wstring";
    }

    public String relativeName(ContainedNode node, ContainerNode scope) {
        return this.relativeName(node, scope, "::", false);
    }

    public static final String relativize(String name, ContainerNode scope) {
        if (scope.kind() == 17) {
            return name;
        }
        return IDLMapper.relativize(name, ((ContainedNode)((Object)scope))._beFullName);
    }

    public static final String relativize(String name, String scope) {
        return TypeMapper.relativize(name, scope, "::", false);
    }
}

